package gov.va.vinci.dart.json.builder;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import com.ibm.icu.text.SimpleDateFormat;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Event;
import gov.va.vinci.dart.biz.EventSummary;
import gov.va.vinci.dart.biz.EventType;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.json.EventView;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestEventViewBuilder extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}

	@Test
	public void testOne() throws Exception {
		EventViewBuilder builder = new EventViewBuilder();
		
		try {
			builder.build((Event)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}

		Request request = DartObjectFactory.getInstance().getRequestDAO().findById(1);
		
		Event event = Event.create(EventType.INITIATE_REQUEST, request, "DNS");
		java.util.Date date = event.getCreatedOn();
		
		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");

		EventView ev = builder.build(event);
		Assert.assertNotNull(ev);
		Assert.assertEquals(ev.getDescription(), "description");
		//Assert.assertEquals(ev.getDateTime(), sdf.format(date));
		Assert.assertEquals(ev.getPerson(), "DNS");
	}
	
	@Test
	public void testTwo() throws Exception {
		EventViewBuilder builder = new EventViewBuilder();
		
		try {
			builder.build((EventSummary)null);
			Assert.fail("Expected NullPointerException");
		} catch (NullPointerException e) {}
		
		java.sql.Timestamp now = new java.sql.Timestamp(System.currentTimeMillis());
		
		EventSummary summary = new EventSummary();
		summary.setDescription("description");
		summary.setCreatedBy("DNS");
		summary.setCreatedOn(now);

		SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy hh:mm aa");

		EventView ev = builder.build(summary);
		Assert.assertNotNull(ev);
		Assert.assertEquals(ev.getDescription(), "description");
		//Assert.assertEquals(ev.getDateTime(), sdf.format(now));
		Assert.assertEquals(ev.getPerson(), "DNS");
	}
	
}
